<?php
########################## util.php ###########################
#
# Detail: SQL Bibliothek MYSQLi (2015)
#
###############################################################

class DB_MYSQL {
  
  var $host  = "localhost";

    var $database = "easyoffe_adminumzugszentrale";
	var $user  = "easyoffe_adminum";
	var $password = "SS20172017.";
 
	var $transaction_on = true;  // untersttzt die Datenbank transaktionen (true|false)
	var $halt_on_error = true;   // nach einem Fehler anhalten (true|false)
	var $debug_on	= false;       // debug-Modus (true|false)
	
	var $link_id	= 0;
	var $query_id	= 0;
	var $errno		= 0;
	var $error		= "";
	var $interrno = 0;
	var $interror = "";
	var $row;
	var $record		= array();
	var $in_transact = false;
	var $fieldnames=array();
	
	function insert_id() {
		// ID des zuletzt eingefgten Datensatzes (autoincrement-Feld)
		return mysqli_insert_id($this->link_id);
	}
	
	function num_rows() {
		// Anzahl der gefundenen Datenstze
		return mysqli_num_rows($this->query_id);
	}
	
	function num_fields() {
		// Anzahl der Felder
		return mysqli_num_fields($this->query_id);
	}
	
	function real_escape_string($value) {
		// mysqli_real_escape_string
		return mysqli_real_escape_string($this->link_id, $value);
	}
	
	function f($name) {
		// Feld "$name" des aktuellen Datensatzes zurckliefern
		$value="";
		
		if(strpos($name,".")) {
			if(count($this->fieldnames)==0) {
				$this->get_fieldnames();
			}
			$pos=array_search($name,$this->fieldnames);
			
			if($pos!==false) {
				$value=$this->record[$pos];
			} else {
				$value=$this->record[substr($name,strpos($name,".")+1)];
			}
			
		} else {
			$value=$this->record[$name];
		}
		return $value;
	}
	
	function affected_rows() {
		// Anzahl der betroffenen Datenstze (Update / Delete)
		return @mysqli_affected_rows($this->link_id);
	}
	
	function halt() {
		// Fehlerausgabe (muss an Auftritt angepasst werden!)
		if($this->halt_on_error) {
			printf("<p><strong>Database error:</strong> %s<br />\n",$this->interror);
			printf("<strong>MYSQLI ERROR: </strong>%s (%s)</p>\n",$this->errno, $this->error);
			die("Session died. " . mysqli_connect_error() );
		}
	}
	
	function debug_msg($msg) {
		// Debug-infos ausgeben
		if($this->debug_on) {
			printf("<br /><strong>DEBUG:</strong> %s<br />",$msg);
		}
	}
	
	function connect() {
		// Datenbankverbindung aufbauen
		$this->debug_msg("Function Connect");
		
	
		if( $this->link_id === 0 ) {
			
			$this->link_id = mysqli_connect($this->host, $this->user, $this->password, $this->database);
			# or die("Error " . mysqli_error($this->link_id)); 
			
			if(!$this->link_id) {
				$this->interrno=1;
				$this->interror="Link ID == false, connect failed";
				$this->halt();
			} else {
				$this->debug_msg("Link established");
			}
			
			if(	!mysqli_query($this->link_id, sprintf("use %s", $this->database) )) {
				$this->interrno=2;
				$this->interror="cannot use database ".$this->database;
				$this->halt();
			} else {
				$this->debug_msg("Database selected");
			}
			
		} else {
			$this->debug_msg("Link already established");
		}
	}
	
	function query ($query_string) {
		// SQL ausfhren
		$this->debug_msg("Function Query started");
		$this->debug_msg($query_string);
		$this->connect();
		
		$this->query_id = mysqli_query($this->link_id, $query_string);
		$this->row=0;
		$this->fieldnames=array();		
		$this->errno = mysqli_errno($this->link_id);
		$this->error = mysqli_error($this->link_id);
		
		if(!$this->query_id) {
			$this->interrno=3;
			$this->interror="Invalid SQL: ".$query_string;
			$this->halt();
		}
		return $this->query_id;
	}
	
	function next_record() {
		// nchster Datensatz
		$this->debug_msg("Function next");
		
		$this->record = mysqli_fetch_array($this->query_id);
		$this->row += 1;
		$this->errno = mysqli_errno($this->link_id);
		$this->error = mysqli_error($this->link_id);
		$stat = is_array($this->record);
		
		if(!$stat) {
			mysqli_free_result($this->query_id);
			$this->query_id=0;
		}
		return $stat;
	}
	
	function seek($pos) {
		// auf bestimmten Datensatz positionieren
		$status = mysqli_data_seek($this->query_id, $pos);
		if($status)
			$this->row=$pos;
		return;
	}
	
	function get_fieldnames() {
		// Ermitteln der vollstndigen Feldnamen incl. der Tabellennamen
		if($this->query_id) {
			$rows = mysqli_num_fields($this->query_id);
			
			for($i=0;$i<$rows;$i++) {
				$field = mysqli_fetch_field($this->query_id, $i);
				if($field->table != "Array") {
					$this->fieldnames[$i]=$field->table.".".$field->name;
				}
			}
		}
	}
	
	// Fehlerbehandlung extern steuern
	function halt_on_error($status) {
		$this->halt_on_error=$status;
	} 
	
	function error() {
		return ($this->interrno!=0 || $this->errno!=0);
	}
	
	function get_error() {
		return array ($this->errno,$this->error,$this->interrno,$this->interror);
	}
	
	// Transaktionshandling
	function begin_work() {
		if($this->transaction_on && !$this->in_transact) {
			$this->query("BEGIN");
				$this->in_transact=true;
		}
		return;
	}
	
	function commit_work() {
		if($this->in_transact) {
			$this->query("COMMIT");
			$this->in_transact=false;
		}
		return;
	}
	
	function rollback_work() {
		if($this->in_transact) {
			$this->query("ROLLBACK");
			$this->in_transact=false;
		}
		return;
	}
	
}